/*
 * Decompiled with CFR 0.152.
 */
package installer.golden;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileLock;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Main
extends JDialog
implements Runnable {
    private AppSetup app;
    private JFileChooser chooserDir;
    private URL zipURL;
    private File extractDir;
    private boolean extracting;
    private boolean cancelling;
    private boolean cancelled;
    private File executableFile;
    private boolean completed;
    private DecimalFormat formatBytes;
    private static String lang;
    private static ResourceBundle bundle;
    private static FileLock lock;
    private JButton btnBrowse;
    private JButton btnCancel;
    private JButton btnInstallTo;
    private JCheckBox chkLaunchApp;
    private JLabel lblAppVersion;
    private JLabel lblCompleted;
    private JLabel lblDescription;
    private JLabel lblEnglish;
    private JLabel lblExtract;
    private JLabel lblIcon;
    private JLabel lblIndonesia;
    private JLabel lblInstallTo;
    private JLabel lblPrevVersion;
    private JLabel lblTitle;
    private JPanel pnlButtons;
    private JPanel pnlCompleted;
    private JPanel pnlExtract;
    private JPanel pnlInstall;
    private JPanel pnlInstallTo;
    private JPanel pnlMain;
    private JProgressBar progressExtract;
    private JSeparator separator;
    private JTextField txtAppVersion;
    private JTextField txtCompleted;
    private JTextField txtInstallTo;
    private JTextField txtPrevVersion;
    static /* synthetic */ Class class$installer$golden$Main;
    static /* synthetic */ Class class$java$awt$Image;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Main(AppSetup app, String defaultInstallDir) {
        ImageIcon icon;
        block13: {
            InputStream is;
            block12: {
                super(Main.createEmptyFrame(), Main.replaceBundle("title.bar", app.appName));
                this.formatBytes = new DecimalFormat("0.##");
                this.app = app;
                this.initComponents();
                this.lblTitle.setText(Main.replace(this.lblTitle.getText(), app.appName));
                this.lblDescription.setText(Main.replace(this.lblDescription.getText(), app.appName));
                this.showCurrentVersion(app.appVersion);
                icon = null;
                is = null;
                is = this.getClass().getResourceAsStream("Main$Log.closs");
                if (is == null) break block12;
                icon = new ImageIcon(ImageIO.read(is));
            }
            Object var7_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block13;
            }
            catch (Exception ex2) {}
            break block13;
            {
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var7_6 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block13;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (icon != null) {
            this.lblIcon.setIcon(icon);
        }
        this.txtInstallTo.setText(defaultInstallDir != null && defaultInstallDir.length() > 0 ? defaultInstallDir : app.appDirectory);
        this.checkInstallDirectory();
        this.txtInstallTo.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                Main.this.checkInstallDirectory();
            }

            public void removeUpdate(DocumentEvent e) {
                Main.this.checkInstallDirectory();
            }
        });
        this.pack();
        Main.boundOwner(this);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.btnInstallTo.requestFocus();
    }

    private synchronized void initChooserDir(String currentDir) {
        if (this.chooserDir == null) {
            this.chooserDir = new JFileChooser(new File("."));
            this.chooserDir.setFileSelectionMode(1);
        }
        if (currentDir != null && (currentDir = currentDir.trim()).length() > 0) {
            File f = new File(currentDir);
            this.chooserDir.setCurrentDirectory(f);
            this.chooserDir.ensureFileIsVisible(f);
        }
        this.chooserDir.rescanCurrentDirectory();
    }

    private void browse() {
        this.initChooserDir(this.txtInstallTo.getText());
        int result = this.chooserDir.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        this.txtInstallTo.setText(this.chooserDir.getSelectedFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInstallDirectory() {
        String prevVersion;
        block21: {
            prevVersion = null;
            String installDir = this.txtInstallTo.getText();
            try {
                File versionFile = new File(installDir, "version");
                if (!versionFile.isFile()) break block21;
                InputStreamReader isr = null;
                BufferedReader buff = null;
                try {
                    isr = new InputStreamReader(new FileInputStream(versionFile));
                    buff = new BufferedReader(isr);
                    prevVersion = buff.readLine();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (buff != null) {
                            buff.close();
                        }
                    }
                    catch (Exception ex) {}
                    try {
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.showPreviousVersion(prevVersion);
    }

    private void showCurrentVersion(String version) {
        if (version == null || version.length() == 0) {
            this.lblAppVersion.setVisible(false);
            this.txtAppVersion.setVisible(false);
        } else {
            this.txtAppVersion.setText(version);
        }
    }

    private void showPreviousVersion(String prevVersion) {
        if (prevVersion == null || prevVersion.length() == 0) {
            this.lblPrevVersion.setVisible(false);
            this.txtPrevVersion.setVisible(false);
            this.txtPrevVersion.setText("");
        } else {
            this.lblPrevVersion.setVisible(true);
            this.txtPrevVersion.setVisible(true);
            this.txtPrevVersion.setText(prevVersion);
        }
    }

    private void showOperation(String operation) {
        this.extracting = false;
        this.cancelled = false;
        ((CardLayout)this.pnlInstall.getLayout()).show(this.pnlInstall, operation);
        if ("INSTALL".equals(operation)) {
            this.btnInstallTo.setVisible(true);
            this.btnInstallTo.requestFocus();
            this.lblEnglish.setVisible(true);
            this.lblIndonesia.setVisible(true);
        } else if ("EXTRACT".equals(operation)) {
            this.lblExtract.setText(Main.getBundle().getString("label.extracting"));
            this.btnInstallTo.setVisible(false);
            this.lblEnglish.setVisible(false);
            this.lblIndonesia.setVisible(false);
        } else if ("COMPLETED".equals(operation)) {
            this.completed = true;
            this.lblPrevVersion.setVisible(false);
            this.txtPrevVersion.setVisible(false);
            this.btnCancel.setText(Main.getBundle().getString("button.finish"));
            this.btnCancel.requestFocus();
            if (this.executableFile == null) {
                this.chkLaunchApp.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double unzipFile(InputStream is, File outputDir, double totalSize) {
        zis = null;
        f = null;
        bos = null;
        entry = null;
        buffer = new byte[1024];
        bytesRead = 0;
        totalRead = 0.0;
        readSize = totalSize == 0.0;
        errorMessage = null;
        listFiles = readSize != false ? null : new ArrayList<File>();
        listFilesOld = readSize != false ? null : new ArrayList<File>();
        totalSizeText = readSize != false ? null : this.getFilesizeDescription(totalSize);
        outputDirLen = 0;
        try {
            if (!readSize) {
                outputDirText = outputDir.getAbsolutePath();
                try {
                    outputDirText = outputDir.getCanonicalPath();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                outputDirLen = outputDirText.length() + 1;
                this.lblCompleted.setText(Main.replace(this.lblCompleted.getText(), totalSizeText));
                this.txtCompleted.setText(outputDirText);
                this.chkLaunchApp.setText(Main.replace(this.chkLaunchApp.getText(), this.app.appName));
            }
            zis = new ZipInputStream(new BufferedInputStream(is));
            while ((entry = zis.getNextEntry()) != null) {
                name = entry.getName();
                if (!name.startsWith(this.app.appDirectory)) continue;
                name = name.substring(this.app.appDirectory.length() + 1);
                if (readSize) {
                    totalSize += (double)entry.getSize();
                    continue;
                }
                f = new File(outputDir, name);
                if (entry.isDirectory()) {
                    listFiles.add(f);
                    f.mkdirs();
                    continue;
                }
                parent = f.getParentFile();
                parent.mkdirs();
                path = f.getAbsolutePath();
                try {
                    path = f.getCanonicalPath();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.progressExtract.setString(path.substring(outputDirLen));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                f = new File(parent, "~$" + f.getName());
                listFiles.add(f);
                bos = new BufferedOutputStream(new FileOutputStream(f));
                while ((bytesRead = zis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                    this.progressExtract.setValue((int)((totalRead += (double)bytesRead) / totalSize * 100.0));
                    this.lblExtract.setText(Main.replaceBundle("label.extracting_progress", new String[]{this.getFilesizeDescription(totalRead), totalSizeText}));
                    while (this.cancelling) {
                        Thread.sleep(100L);
                    }
                    if (!this.cancelled) continue;
                    ex = -1.0;
                    return ex;
                }
                bos.flush();
                bos.close();
                bos = null;
            }
            if (!readSize) {
                i = 0;
                while (i < listFiles.size()) {
                    result = (File)listFiles.get(i);
                    if (result.isFile()) {
                        dir = result.getParentFile();
                        dstFile = new File(dir, dstName = result.getName().substring(2));
                        if (dstFile.exists()) {
                            oldFile = new File(dir, dstName + ".old");
                            if (!dstFile.renameTo(oldFile)) {
                                errorMessage = Main.getBundle().getString("error_extract_in_use");
                                ori = -1.0;
                                return ori;
                            }
                            dstFile = new File(dir, dstName);
                            listFilesOld.add(dstFile);
                        }
                        if (!result.renameTo(dstFile)) {
                            errorMessage = Main.getBundle().getString("error_extract_in_use");
                            oldFile = -1.0;
                            return oldFile;
                        }
                        listFiles.set(i, dstFile);
                    }
                    ++i;
                }
                i = 0;
                while (i < listFilesOld.size()) {
                    old = (File)listFilesOld.get(i);
                    old = new File(old.getParentFile(), old.getName() + ".old");
                    old.delete();
                    ++i;
                }
            }
            i = totalSize;
            return i;
        }
        catch (Exception ex) {
            errorMessage = Main.getBundle().getString("error_extract_unknown");
            ex.printStackTrace();
            var20_24 = -1.0;
            return var20_24;
        }
        finally {
            if (bos != null) {
                try {
                    bos.flush();
                    bos.close();
                }
                catch (Exception e) {}
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
            if (readSize != false) return var20_24;
            if (!this.cancelled) {
                if (errorMessage == null) return var20_24;
            }
            try {
                i = 0;
                if (true) ** GOTO lbl156
lbl135:
                // 2 sources

                while (true) {
                    try {
                        i = 0;
                        while (i < listFilesOld.size()) {
                            ori = (File)listFilesOld.get(i);
                            old = new File(ori.getParentFile(), ori.getName() + ".old");
                            old.renameTo(ori);
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (errorMessage == null) return var20_24;
                    JOptionPane.showMessageDialog(this, Main.replaceBundle("error_extract_header", errorMessage), Main.getBundle().getString("title.install"), 0);
                    return var20_24;
                }
                do {
                    if ((result = (File)listFiles.get(i)).isFile()) {
                        result.delete();
                    }
                    ++i;
lbl156:
                    // 2 sources

                } while (i < listFiles.size());
                i = 0;
                while (i < listFiles.size()) {
                    result = (File)listFiles.get(i);
                    if (result.isDirectory() && ((files = result.listFiles()) == null || files.length == 0)) {
                        result.delete();
                    }
                    ++i;
                }
                files = outputDir.listFiles();
                if (files != null && files.length != 0) ** GOTO lbl135
                outputDir.delete();
                ** continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void run() {
        block16: {
            this.extracting = true;
            try {
                double totalSize = this.unzipFile(this.zipURL.openStream(), this.extractDir, 0.0);
                if (totalSize <= 0.0) {
                    this.extracting = false;
                    JOptionPane.showMessageDialog(this, Main.replaceBundle("error_extract_header", Main.getBundle().getString("error_extract_unknown")), Main.getBundle().getString("title.install"), 0);
                    this.showOperation("INSTALL");
                    return;
                }
                if (this.unzipFile(this.zipURL.openStream(), this.extractDir, totalSize) > 0.0) {
                    try {
                        String exeName = this.app.getExecutableFilename();
                        File executable = new File(this.extractDir, exeName);
                        Preferences p = Main.getPreferences(this.app.appName);
                        if (p != null) {
                            String extractDirText = this.extractDir.getAbsolutePath();
                            try {
                                extractDirText = this.extractDir.getCanonicalPath();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            p.put("dir", extractDirText);
                            if (executable.isFile()) {
                                p.put("exe", exeName);
                                this.executableFile = executable;
                            }
                            if (lang != null && lang.length() > 0) {
                                p.put("lang", lang);
                            } else {
                                p.remove("lang");
                            }
                            p.flush();
                        }
                        try {
                            if (executable.isFile()) {
                                Class<?> fileClass = Class.forName("java.io.File");
                                Method setExecutable = fileClass.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
                                setExecutable.invoke((Object)executable, Boolean.TRUE, Boolean.FALSE);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.showOperation("COMPLETED");
                    break block16;
                }
                this.showOperation("INSTALL");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.extracting = false;
                JOptionPane.showMessageDialog(this, Main.getBundle().getString("corrupted_setup_file"), Main.getBundle().getString("title.install"), 0);
                this.showOperation("INSTALL");
            }
        }
    }

    private void install() {
        String appExecutableName;
        File oldExecutable;
        File outputDir = new File(this.txtInstallTo.getText());
        if (outputDir.isDirectory()) {
            String currentVersion = this.txtAppVersion.isVisible() ? this.txtAppVersion.getText() : "";
            String previousVersion = this.txtPrevVersion.isVisible() ? this.txtPrevVersion.getText() : "";
            String outputDirPath = outputDir.getAbsolutePath();
            try {
                outputDirPath = outputDir.getCanonicalPath();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (currentVersion.length() > 0 && previousVersion.length() > 0) {
                if (JOptionPane.showConfirmDialog(this, Main.replaceBundle("begin_extract", outputDirPath), Main.getBundle().getString("title.install"), 2) != 0) {
                    return;
                }
                if (!currentVersion.equals(previousVersion) && JOptionPane.showConfirmDialog(this, Main.replaceBundle("confirm_extract_update", new String[]{this.app.appName, previousVersion, currentVersion}), Main.getBundle().getString("title.install"), 0) != 0) {
                    return;
                }
            } else {
                if (JOptionPane.showConfirmDialog(this, Main.replaceBundle("begin_extract", outputDirPath), Main.getBundle().getString("title.install"), 2) != 0) {
                    return;
                }
                boolean notEmpty = false;
                try {
                    File[] files = outputDir.listFiles();
                    notEmpty = files != null && files.length > 0;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (notEmpty && JOptionPane.showConfirmDialog(this, Main.getBundle().getString("confirm_extract_not_empty"), Main.getBundle().getString("title.install"), 0, 2) != 0) {
                    return;
                }
            }
        } else {
            String outputDirPath = outputDir.getAbsolutePath();
            try {
                outputDirPath = outputDir.getCanonicalPath();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (JOptionPane.showConfirmDialog(this, Main.replaceBundle("begin_extract", outputDirPath), Main.getBundle().getString("title.install"), 2) != 0) {
                return;
            }
        }
        if ((oldExecutable = new File(outputDir, appExecutableName = this.app.getExecutableFilename(-1))).isFile()) {
            File tmpExecutable = new File(outputDir, "~$oldexec");
            if (!oldExecutable.renameTo(tmpExecutable)) {
                JOptionPane.showMessageDialog(this, Main.replaceBundle("app_is_running", this.app.appName), Main.getBundle().getString("title.install"), 2);
                return;
            }
            tmpExecutable.renameTo(new File(outputDir, appExecutableName));
        }
        try {
            URL url;
            this.zipURL = url = (class$installer$golden$Main == null ? (class$installer$golden$Main = Main.class$("installer.golden.Main")) : class$installer$golden$Main).getProtectionDomain().getCodeSource().getLocation();
            this.extractDir = outputDir;
            this.progressExtract.setString("");
            this.progressExtract.setMaximum(100);
            this.showOperation("EXTRACT");
            new Thread(this).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, Main.replaceBundle("error_extract_header", Main.getBundle().getString("error_extract_unknown")), Main.getBundle().getString("title.install"), 0);
            this.showOperation("INSTALL");
        }
    }

    private void finish() {
        if (this.chkLaunchApp.isSelected() && this.executableFile != null) {
            Main.launch(this.executableFile);
        }
        this.exit();
    }

    private void cancel() {
        if (this.completed) {
            return;
        }
        this.cancelling = true;
        int result = JOptionPane.showConfirmDialog(this, Main.getBundle().getString("confirm_cancel"), Main.getBundle().getString("title.cancel"), 0, 2);
        this.cancelling = false;
        if (result != 0) {
            return;
        }
        if (this.extracting) {
            this.cancelled = true;
        } else {
            this.exit();
        }
    }

    private void exit() {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Frame createEmptyFrame() {
        Image icon;
        Frame frm;
        block15: {
            InputStream is;
            block14: {
                frm = new Frame("Setup");
                icon = null;
                is = null;
                is = (class$installer$golden$Main == null ? (class$installer$golden$Main = Main.class$("installer.golden.Main")) : class$installer$golden$Main).getResourceAsStream("Main$Ico.closs");
                if (is == null) break block14;
                icon = new ImageIcon(ImageIO.read(is)).getImage();
            }
            Object var5_3 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block15;
            }
            catch (Exception ex2) {}
            break block15;
            {
                catch (Exception ex) {
                    ex.printStackTrace();
                    var5_3 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block15;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (icon != null) {
            frm.setIconImage(icon);
            try {
                Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
                Method getApplication = applicationClass.getMethod("getApplication", null);
                Object application = getApplication.invoke(null, (Object[])null);
                Method setDockIconImage = applicationClass.getMethod("setDockIconImage", class$java$awt$Image == null ? (class$java$awt$Image = Main.class$("java.awt.Image")) : class$java$awt$Image);
                setDockIconImage.invoke(application, icon);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        frm.setSize(0, 0);
        frm.setResizable(false);
        frm.setUndecorated(true);
        frm.setLocationRelativeTo(null);
        return frm;
    }

    private static void boundOwner(final Dialog dialog) {
        final Window owner = dialog.getOwner();
        Image icon = Main.getWindowIcon(dialog);
        ((Frame)owner).setTitle(dialog.getTitle());
        if (icon != null) {
            Main.setWindowIcon(owner, icon);
        }
        owner.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                e.setSource(dialog);
                dialog.dispatchEvent(e);
                if (owner.isDisplayable() && dialog.isDisplayable()) {
                    dialog.setVisible(true);
                }
            }

            public void windowClosing(WindowEvent e) {
                e.setSource(dialog);
                dialog.dispatchEvent(e);
            }
        });
        dialog.setLocationRelativeTo(owner.getWidth() == 0 || owner.getHeight() == 0 ? null : owner);
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                if (owner.isDisplayable() && dialog.isDisplayable()) {
                    owner.setVisible(true);
                }
            }

            public void componentHidden(ComponentEvent e) {
                if (owner.isDisplayable() && dialog.isDisplayable()) {
                    owner.setVisible(false);
                }
            }

            public void componentMoved(ComponentEvent e) {
                if (owner.isDisplayable() && dialog.isDisplayable()) {
                    owner.setLocationRelativeTo(dialog);
                }
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                dialog.removeWindowListener(this);
                ((Frame)owner).dispose();
            }
        });
    }

    private static Image getWindowIcon(Window window) {
        if (window == null) {
            return null;
        }
        if (window instanceof Frame) {
            return ((Frame)window).getIconImage();
        }
        try {
            Method getIconImages = window.getClass().getMethod("getIconImages", null);
            List list = (List)getIconImages.invoke((Object)window, (Object[])null);
            return (Image)list.get(0);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void setWindowIcon(Window window, Image icon) {
        if (window instanceof Frame) {
            ((Frame)window).setIconImage(icon);
        } else {
            try {
                Method setIconImage = window.getClass().getMethod("setIconImage", class$java$awt$Image == null ? (class$java$awt$Image = Main.class$("java.awt.Image")) : class$java$awt$Image);
                setIconImage.invoke((Object)window, icon);
            }
            catch (Exception ex) {}
        }
    }

    public static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("installer.golden.lang");
        }
        return bundle;
    }

    private static void setLanguage(String language) {
        try {
            Locale locale = null;
            if ("IND".equalsIgnoreCase(language)) {
                locale = new Locale("in", "ID");
            }
            Locale.setDefault(locale != null ? locale : new Locale("en", "US"));
            lang = language;
        }
        catch (Exception ex) {}
    }

    public void changeLanguage(String language) {
        Main.setLanguage(language);
        bundle = ResourceBundle.getBundle("installer.golden.lang");
        this.dispose();
        Main.showMain(this.app, this.txtInstallTo.getText());
    }

    private static String replaceBundle(String text, String replace) {
        return Main.replace(Main.getBundle().getString(text), new String[]{replace});
    }

    private static String replaceBundle(String text, String[] replace) {
        return Main.replace(Main.getBundle().getString(text), replace);
    }

    private static String replace(String text, String replace) {
        return Main.replace(text, new String[]{replace});
    }

    private static String replace(String text, String[] replace) {
        String[] find = new String[replace.length];
        int i = 0;
        while (i < find.length) {
            find[i] = "{" + i + "}";
            ++i;
        }
        return Main.replace(text, find, replace);
    }

    private static String replace(String text, String[] find, String[] replace) {
        StringBuffer buff = new StringBuffer(text);
        int i = 0;
        while (i < find.length) {
            int index = 0;
            do {
                if ((index = buff.indexOf(find[i], index)) == -1) continue;
                buff.replace(index, index + find[i].length(), replace[i]);
                index += replace[i].length();
            } while (index != -1);
            ++i;
        }
        return buff.toString();
    }

    private static String replace(String text, String find, String replace) {
        StringBuffer buff = new StringBuffer(text);
        int index = 0;
        do {
            if ((index = buff.indexOf(find, index)) == -1) continue;
            buff.replace(index, index + find.length(), replace);
            index += replace.length();
        } while (index != -1);
        return buff.toString();
    }

    private static void showMain(final AppSetup app, final String defaultInstallDir) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Main(app, defaultInstallDir);
            }
        });
    }

    private static void launch(File executable) {
        try {
            Process p = Runtime.getRuntime().exec(executable.getAbsolutePath(), null, executable.getParentFile());
            System.exit(0);
            return;
        }
        catch (Exception ex) {
            return;
        }
    }

    private String getFilesizeDescription(double bytes) {
        if (bytes <= 0.0) {
            return "";
        }
        int level = 0;
        while (bytes > 1024.0) {
            bytes /= 1024.0;
            if (++level >= 4) break;
        }
        String text = this.formatBytes.format(bytes) + " ";
        switch (level) {
            case 0: {
                text = text + "B";
                break;
            }
            case 1: {
                text = text + "KB";
                break;
            }
            case 2: {
                text = text + "MB";
                break;
            }
            case 3: {
                text = text + "GB";
                break;
            }
            case 4: {
                text = text + "TB";
            }
        }
        return text;
    }

    private static boolean checkInstance(String name, String ext) {
        try {
            File parent = new File((String)System.getProperties().get("java.io.tmpdir"));
            File file = new File(parent, name + "-setup." + ext);
            file.delete();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.createNewFile()) {
                file.deleteOnExit();
                lock = new FileOutputStream(file).getChannel().lock();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Preferences getPreferences(String appName) {
        Preferences p = null;
        StringBuffer sb = new StringBuffer("/installer/golden/");
        int i = 0;
        while (i < appName.length()) {
            char c = appName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
            ++i;
        }
        String node = sb.toString();
        try {
            p = Preferences.userRoot().node(node);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return p;
    }

    private void initComponents() {
        this.lblIcon = new JLabel();
        this.pnlMain = new JPanel();
        this.lblTitle = new JLabel();
        this.lblDescription = new JLabel();
        this.lblAppVersion = new JLabel();
        this.txtAppVersion = new JTextField();
        this.lblPrevVersion = new JLabel();
        this.txtPrevVersion = new JTextField();
        this.pnlInstall = new JPanel();
        this.pnlInstallTo = new JPanel();
        this.lblInstallTo = new JLabel();
        this.txtInstallTo = new JTextField();
        this.btnBrowse = new JButton();
        this.pnlExtract = new JPanel();
        this.lblExtract = new JLabel();
        this.progressExtract = new JProgressBar();
        this.pnlCompleted = new JPanel();
        this.lblCompleted = new JLabel();
        this.txtCompleted = new JTextField();
        this.chkLaunchApp = new JCheckBox();
        this.pnlButtons = new JPanel();
        this.separator = new JSeparator();
        this.lblEnglish = new JLabel();
        this.lblIndonesia = new JLabel();
        this.btnInstallTo = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Main.this.formWindowClosing(evt);
            }
        });
        this.lblIcon.setVerticalAlignment(1);
        this.getContentPane().add((Component)this.lblIcon, "West");
        this.pnlMain.setLayout(new GridBagLayout());
        this.pnlMain.setBackground(Color.white);
        this.pnlMain.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(this.lblTitle.getFont().getStyle() | 1));
        this.lblTitle.setText(Main.getBundle().getString("label.title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.pnlMain.add((Component)this.lblTitle, gridBagConstraints);
        this.lblDescription.setText(Main.getBundle().getString("label.description"));
        this.lblDescription.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        this.pnlMain.add((Component)this.lblDescription, gridBagConstraints);
        this.lblAppVersion.setText(Main.getBundle().getString("label.version"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 10);
        this.pnlMain.add((Component)this.lblAppVersion, gridBagConstraints);
        this.txtAppVersion.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.pnlMain.add((Component)this.txtAppVersion, gridBagConstraints);
        this.lblPrevVersion.setText(Main.getBundle().getString("label.old_version"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlMain.add((Component)this.lblPrevVersion, gridBagConstraints);
        this.txtPrevVersion.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMain.add((Component)this.txtPrevVersion, gridBagConstraints);
        this.pnlInstall.setLayout(new CardLayout());
        this.pnlInstall.setOpaque(false);
        this.pnlInstallTo.setLayout(new GridBagLayout());
        this.pnlInstallTo.setOpaque(false);
        this.lblInstallTo.setText(Main.getBundle().getString("label.extract_to"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.pnlInstallTo.add((Component)this.lblInstallTo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlInstallTo.add((Component)this.txtInstallTo, gridBagConstraints);
        this.btnBrowse.setText("...");
        this.btnBrowse.setMargin(new Insets(2, 5, 2, 5));
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.btnBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        this.pnlInstallTo.add((Component)this.btnBrowse, gridBagConstraints);
        this.pnlInstall.add((Component)this.pnlInstallTo, "INSTALL");
        this.pnlExtract.setLayout(new GridBagLayout());
        this.pnlExtract.setOpaque(false);
        this.lblExtract.setText(Main.getBundle().getString("label.extracting"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.pnlExtract.add((Component)this.lblExtract, gridBagConstraints);
        this.progressExtract.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlExtract.add((Component)this.progressExtract, gridBagConstraints);
        this.pnlInstall.add((Component)this.pnlExtract, "EXTRACT");
        this.pnlCompleted.setLayout(new GridBagLayout());
        this.pnlCompleted.setOpaque(false);
        this.lblCompleted.setFont(this.lblCompleted.getFont().deriveFont(this.lblCompleted.getFont().getStyle() | 1));
        this.lblCompleted.setText(Main.getBundle().getString("label.completed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlCompleted.add((Component)this.lblCompleted, gridBagConstraints);
        this.txtCompleted.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.pnlCompleted.add((Component)this.txtCompleted, gridBagConstraints);
        this.chkLaunchApp.setSelected(true);
        this.chkLaunchApp.setText(Main.getBundle().getString("label.launch"));
        this.chkLaunchApp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkLaunchApp.setMargin(new Insets(0, 0, 0, 0));
        this.chkLaunchApp.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlCompleted.add((Component)this.chkLaunchApp, gridBagConstraints);
        this.pnlInstall.add((Component)this.pnlCompleted, "COMPLETED");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)this.pnlInstall, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pnlButtons.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlButtons.add((Component)this.separator, gridBagConstraints);
        this.lblEnglish.setIcon(new ImageIcon(this.getClass().getResource("/installer/golden/eng.png")));
        this.lblEnglish.setToolTipText("English");
        this.lblEnglish.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblEnglish.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Main.this.lblEnglishMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.pnlButtons.add((Component)this.lblEnglish, gridBagConstraints);
        this.lblIndonesia.setIcon(new ImageIcon(this.getClass().getResource("/installer/golden/ind.png")));
        this.lblIndonesia.setToolTipText("Bahasa Indonesia");
        this.lblIndonesia.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblIndonesia.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Main.this.lblIndonesiaMousePressed(evt);
            }
        });
        this.pnlButtons.add((Component)this.lblIndonesia, new GridBagConstraints());
        this.btnInstallTo.setText(Main.getBundle().getString("button.extract"));
        this.btnInstallTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.btnInstallToActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.pnlButtons.add((Component)this.btnInstallTo, gridBagConstraints);
        this.btnCancel.setText(Main.getBundle().getString("button.cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        this.pnlButtons.add((Component)this.btnCancel, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.pack();
    }

    private void lblIndonesiaMousePressed(MouseEvent evt) {
        this.changeLanguage("IND");
    }

    private void lblEnglishMousePressed(MouseEvent evt) {
        this.changeLanguage("ENG");
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (!this.completed) {
            this.cancel();
        } else {
            this.finish();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        this.browse();
    }

    private void btnInstallToActionPerformed(ActionEvent evt) {
        this.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String[] args) {
        File executable;
        boolean launch;
        AppSetup app;
        block81: {
            app = new AppSetup();
            InputStreamReader isr = null;
            BufferedReader buff = null;
            try {
                isr = new InputStreamReader((class$installer$golden$Main == null ? (class$installer$golden$Main = Main.class$("installer.golden.Main")) : class$installer$golden$Main).getResourceAsStream("Main$Set.closs"));
                buff = new BufferedReader(isr);
                String line = null;
                while ((line = buff.readLine()) != null) {
                    if (line.startsWith("appname=")) {
                        app.appName = line.substring("appname=".length());
                        continue;
                    }
                    if (line.startsWith("appdir=")) {
                        app.appDirectory = line.substring("appdir=".length());
                        continue;
                    }
                    if (!line.startsWith("appexe=")) continue;
                    app.appExecutable = line.substring("appexe=".length());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (buff != null) {
                        buff.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (Exception ex) {}
            }
            if (app.appDirectory == null) {
                app.appDirectory = app.appName;
            }
            if (app.appExecutable == null) {
                app.appExecutable = app.appDirectory;
            }
            Preferences p = null;
            try {
                p = Main.getPreferences(app.appName);
                String lang = p.get("lang", "");
                if (lang != null && lang.length() > 0) {
                    Main.setLanguage(lang);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (!Main.checkInstance(app.appName, "ins")) {
                JOptionPane.showMessageDialog(Main.createEmptyFrame(), Main.getBundle().getString("setup_is_already_running"), Main.replace(Main.getBundle().getString("title.bar"), app.appName), 1);
                System.exit(0);
                return;
            }
            isr = null;
            buff = null;
            try {
                InputStream is = (class$installer$golden$Main == null ? (class$installer$golden$Main = Main.class$("installer.golden.Main")) : class$installer$golden$Main).getResourceAsStream("/" + app.appDirectory + "/version");
                if (is != null) {
                    isr = new InputStreamReader(is);
                    buff = new BufferedReader(isr);
                    app.appVersion = buff.readLine();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (buff != null) {
                        buff.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (Exception ex) {}
            }
            launch = false;
            executable = null;
            if (p != null) {
                try {
                    String prevInstallDir;
                    if (app.appVersion == null || app.appVersion.length() <= 0 || (prevInstallDir = p.get("dir", "")).length() <= 0) break block81;
                    app.prevAppDirectory = new File(prevInstallDir);
                    File versionFile = new File(app.prevAppDirectory, "version");
                    if (!versionFile.isFile()) break block81;
                    isr = null;
                    buff = null;
                    try {
                        isr = new InputStreamReader(new FileInputStream(versionFile));
                        buff = new BufferedReader(isr);
                        app.prevAppVersion = buff.readLine();
                        if (app.appVersion.equals(app.prevAppVersion)) {
                            String exeName;
                            String prevExe = p.get("exe", "");
                            if (prevExe.length() > 0 && (executable = new File(app.prevAppDirectory, prevExe)).isFile()) {
                                launch = true;
                            }
                            if (!launch && (executable = new File(app.prevAppDirectory, exeName = app.getExecutableFilename())).isFile()) {
                                launch = true;
                                try {
                                    p.put("exe", exeName);
                                    p.flush();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        try {
                            if (buff != null) {
                                buff.close();
                            }
                        }
                        catch (Exception ex) {}
                        try {
                            if (isr != null) {
                                isr.close();
                            }
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (launch) {
            Main.launch(executable);
        }
        String defaultInstallDir = "";
        try {
            String currentDir;
            if (app.prevAppDirectory != null && app.prevAppDirectory.isDirectory() && (defaultInstallDir = app.prevAppDirectory.getCanonicalPath()).startsWith(currentDir = new File(".").getCanonicalPath()) && ((defaultInstallDir = defaultInstallDir.substring(currentDir.length())).startsWith("/") || defaultInstallDir.startsWith("\\"))) {
                defaultInstallDir = defaultInstallDir.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Main.showMain(app, defaultInstallDir);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AppSetup {
        public String appName;
        public String appDirectory;
        public String appExecutable;
        public String appVersion;
        public File prevAppDirectory;
        public String prevAppVersion;
        public int os;

        private AppSetup() {
        }

        public String getExecutableFilename() {
            block7: {
                if (this.os != 0) break block7;
                this.os = -1;
                try {
                    String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
                    if (osName.indexOf("win") >= 0) {
                        this.os = 1;
                    } else if (osName.indexOf("nux") >= 0) {
                        this.os = 2;
                    } else if (osName.indexOf("mac") >= 0) {
                        this.os = 3;
                    }
                }
                catch (Exception ex) {}
            }
            return this.getExecutableFilename(this.os);
        }

        public String getExecutableFilename(int osType) {
            if (osType == 1) {
                return this.appExecutable + ".exe";
            }
            if (osType == 2) {
                return this.appExecutable + "@Linux.sh";
            }
            if (osType == 3) {
                return this.appExecutable + "@Mac.command";
            }
            return this.appExecutable + ".jar";
        }
    }
}

